/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorScenario;
import filenet.sim.toolkit.viewer.VWSIMAnimatorUser;
import filenet.sim.toolkit.viewer.statistics.resources.VWSIMResource;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class VWSIMUserStatTableModel
extends AbstractTableModel {
    public static final int STAT_USER_NAME_COL = 0;
    public static final int STAT_USER_ASSIGNED_COL = 1;
    public static final int STAT_USER_ACTIVE_COL = 2;
    public static final int STAT_USER_COMPLETED_COL = 3;
    public static final int STAT_USER_COST_COL = 4;
    public static final int STAT_USER_AVERAGE_COST_COL = 5;
    protected VWSIMAnimatorDataModel m_animatorDataModel = null;
    private Vector m_columnNames = new Vector();
    VWTableSorter m_sorter = null;

    public VWSIMUserStatTableModel(VWSIMAnimatorDataModel animatorDataModel) {
        this.createTableSorter();
        this.m_animatorDataModel = animatorDataModel;
        this.initColumnNames();
    }

    VWSIMAnimatorDataModel getDataModel() {
        return this.m_animatorDataModel;
    }

    private void createTableSorter() {
        this.m_sorter = new VWTableSorter(this){

            public void tableChanged(TableModelEvent e) {
                int col = e.getColumn();
                if (e.getType() == 0 && col != 0 && col != -1) {
                    this.fireTableChanged(e);
                } else {
                    super.tableChanged(e);
                    this.sortByColumn(0);
                }
            }
        };
    }

    void initData() {
        this.fireTableDataChanged();
    }

    private VWSIMAnimatorScenario getScenario() {
        if (this.m_animatorDataModel != null) {
            return this.m_animatorDataModel.getScenario();
        }
        return null;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        VWSIMAnimatorUser user = this.getValueAt(row);
        if (user != null) {
            switch (col) {
                case 0: {
                    return user.getName();
                }
                case 1: {
                    return new Integer(user.getAssignedCount());
                }
                case 2: {
                    return new Integer(user.getActiveCount());
                }
                case 3: {
                    return new Integer(user.getCompletedCount());
                }
                case 4: {
                    return new Double(user.getCost());
                }
                case 5: {
                    return new Double(user.getAverageCost());
                }
            }
        }
        return null;
    }

    protected void initColumnNames() {
        this.m_columnNames.addElement(VWSIMResource.s_user_col);
        this.m_columnNames.addElement(VWSIMResource.s_assigned_col);
        this.m_columnNames.addElement(VWSIMResource.s_active_col);
        this.m_columnNames.addElement(VWSIMResource.s_completed_col);
        this.m_columnNames.addElement(VWSIMResource.s_cost_col);
        this.m_columnNames.addElement(VWSIMResource.s_average_cost_col);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 2: 
            case 3: {
                return Integer.class;
            }
            case 4: 
            case 5: {
                return Double.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public int getRowCount() {
        Vector users;
        if (this.getScenario() != null && (users = this.getScenario().getUsers()) != null) {
            return users.size();
        }
        return 0;
    }

    public VWSIMAnimatorUser getValueAt(int row) {
        Object obj;
        Vector users;
        if (this.getScenario() != null && (users = this.getScenario().getUsers()) != null && row < users.size() && (obj = users.elementAt(row)) != null && obj instanceof VWSIMAnimatorUser) {
            return (VWSIMAnimatorUser)obj;
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            return (String)this.m_columnNames.elementAt(col);
        }
        return null;
    }

    public VWTableSorter getTableSorter() {
        return this.m_sorter;
    }

    void releaseResources() {
        this.m_animatorDataModel = null;
        if (this.m_columnNames != null) {
            this.m_columnNames.removeAllElements();
            this.m_columnNames = null;
        }
        this.m_sorter = null;
    }
}

